
/*

	ffld.c--

	Display structure of a dBASE data file.
	Copyright (C) 1991 by Mark W. Schumann

	Mark W. Schumann
	November 1990-August 1991

	Added noextension() December 1990 to more accurately
	determine whether an extension needs to be added to
	the argument.

	July 1991, added wildcard logic and informative
	introduction message.  August 1991, fixed bug in
	error output that caused system to lock up.

	-------------------------------------------------------------------

	To create FFLD.COM with Turbo C, Turbo C++, or Borland C++:

                            	tcc -lt -mt ffld.c

                                    	or

                            	bcc -lt -mt ffld.c

	-------------------------------------------------------------------


	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 1, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <dir.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

#define PATHLEN 79         /* Maximum DOS file specification size */

int datadict = 0;

int noextension (char *);
int ffmatch (char *);
int ff (FILE *, char *);
void info (void);

int main (int argc, char *argv[])

{

char database[PATHLEN];
char *u;
int okay;
struct ffblk fff;
char path[PATHLEN];
char target[PATHLEN];
char *w;
int i;
int dashflag = 0;

	if (argc < 2) {
		fprintf (stderr, "FFLD  Mark W. Schumann, 1991\n");
		fprintf (stderr, "Usenet: catfood@ncoast.org; CI$: 73750,3527\n");
		fprintf (stderr, " Display field structure of a dBASE file.\n");
		fprintf (stderr, " Syntax: FFLD [-d] <database>\n\n");
		fprintf (stderr, " Wildcards and path specifications are valid.\n");
		fprintf (stderr, " The -d option creates a columnar output format.\n");
		fprintf (stderr, " FFLD comes with ABSOLUTELY NO WARRANTY.  It is free software, and\n");
		fprintf (stderr, "  you are welcome to redistribute it under certain conditions; read\n");
		fprintf (stderr, "  the file COPYING for details.\n\n");
		printf ("Database? ");
		fgets (database, PATHLEN, stdin);
		/* Trim the carriage return off the database name. */
		for (u = database; *u; u++) if (*u == '\n') *u = 0;
		ffmatch (database);
		}

	else for (i = 1; i < argc; i++) {
		if (strcmp (argv[i], "--") == 0) {
			dashflag = 1;
			continue;
			}
		if (!dashflag && strcmp (argv[i], "-d") == 0) {
			datadict = 1;
			continue;
			}
		strcpy (database, argv[i]);
		ffmatch (database);
		}

	return 0;
	}

int ffmatch (char *database)

{

FILE *f;
int okay;
struct ffblk fff;
char path[PATHLEN];
char target[PATHLEN];
char *u;
char *w;

	strupr (database);

	/* if (strchr (database, '.') == NULL) */
	if (noextension (database))
		strcat (database, ".DBF");

	for (u = database, w = NULL; *u; u++) {
		if (*u == '\\') w = u;
		}

	/* w now points to the last backslash in database */
	/* path[0] = 0;  Heh, heh... clear the path... */
	memset (path, 0, PATHLEN);
	if (w != NULL) strncpy (path, database, w - database);

	okay = 0;

	if (findfirst (database, &fff, 0) == 0) do {
		strcpy (target, path);
		if (w != NULL) strcat (target, "\\");
		strcat (target, fff.ff_name);
		if ((f = fopen (target, "rb")) != NULL) {
 			ff (f, target);
			fclose (f);
			}
		else {
			fprintf (stderr, "Could not open file %s for input.\n", target);
			fprintf (stderr, "(DOS error code is %d.)\n", _doserrno);
			okay = _doserrno;
			break;
			}
		} while (findnext (&fff) == 0);
	else {
		fprintf (stderr, "Could not find a match for file name %s.\n", database);
		okay = -1;
		}
	return okay;
	}

int ff (FILE *f, char *filename)

{

unsigned int headersize;
unsigned int fieldcount;
short int i;
char buffer[33];
int offset = 1;
int end;
unsigned char id_byte;

	fseek (f, 0L, SEEK_SET);
	fread (&id_byte, 1, sizeof (char), f);
	if (id_byte != 3) {
		fprintf (stderr, "%s is not a dBASE file!\n", filename);
		return 0;
		}

	fseek (f, 8L, SEEK_SET);
	fread (&headersize, 1, sizeof (headersize), f);
	fieldcount = headersize / 32 - 1;

	if (datadict) {
		printf ("*%s\n", filename);
		}
	else {
		if (fieldcount == 1)
			printf ("1 field in database %s:\n", filename);
		else
			printf ("%d fields in database %s:\n", fieldcount, filename);
		printf ("  Field   Name         Type    Len    Dec Offset   End\n");
		}

	for (i = 1; i <= fieldcount; i++) {
		fseek (f, (long) 32 * i, SEEK_SET);
		fread (buffer, 32, sizeof (char), f);

		if (datadict) {
			printf ("%10.10s %c %03d %03d\n",
			 buffer, buffer[11], buffer[16], buffer[17]);
			}

		else {
			printf ("  %3d     %10.10s      %c    %3d",
				i, buffer, buffer[11], buffer[16]);

			if (buffer[11] == 'N')
				printf ("     %2d", buffer[17]);
			else
				printf ("       ");
			}

		end = offset + buffer[16] - 1;
		if (!datadict)
			printf ("   %3d    %3d\n", offset, end);
		offset = end + 1;
		}
	return 0;
	}


int noextension (char *filename)

{

char *ptr;
register int period = 0;

/*
	If the last period is after the last slash, an
	extension exists.  Otherwise no extension exists.
*/

	for (ptr = filename; *ptr; ptr++) {
		if (*ptr == '.') period = 1;
		if (*ptr == '\\') period = 0;
		}
	return !period;
	}
